float4x4 g_view_projection_matrix	: WORLDVIEWPROJ;	//our world view projection matrix
float4x4 g_world_matrix			: WORLD;		//our world matrix
float4	 g_diffuse_mtrl;
float4	 g_ambient_mtrl;

//application to vertex structure
struct a2v
{ 
     float4 position : POSITION0;
     float4 color : COLOR0;
};

//vertex to pixel shader structure
struct v2p
{
     float4 position : POSITION0;
	float4 color : COLOR0;
};


//VERTEX SHADER
void vs( in a2v IN, out v2p OUT ) 
{
	//getting the position of the vertex in the world
    float4 posWorld = mul(IN.position, g_world_matrix);

     //getting to position to object space
    OUT.position = mul(posWorld, g_view_projection_matrix);    
 
    OUT.color = IN.color;
}

//PIXEL SHADER
float4 ps( in v2p IN ) : COLOR
{
    //calculate the color and the normal
   float4 color = IN.color;

   return color + g_ambient_mtrl; 
}

technique Default
{
    pass P0
    {
        VertexShader	= compile vs_3_0 vs();
        PixelShader	= compile ps_2_0 ps();
    }
}
 
